<?php
   /**
    *
    * copyright (c) 2013-2024 Heliac Technologies
    * license https://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo https://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    *
    */

    include "../include/costanti.php";
    include "../include/util.php";
    include "../gUtil/DbManager.php";
    include "../gUtil/ControlloreStringhe.php";
    include "../gUtil/GeneratoreEmail.php";
    include "../gUtil/GestoreUpload.php";
    include "../gUtil/ElaboratoreImmagini.php";
    include "../classi/Comunicazione.php";
    include "../classi/Notifica.php";
    include "../classi/GeneratoreUrl.php";
    
    session_start();
    
    //i dati del database sono definiti nel file costanti.php
    $geecomDb     = new DbManager($costantiDatabase);
    $impostazioni = recuperaImpostazioni($geecomDb);
    
    if(isset($_GET["operazione"])) {
        $operazione    = filter_input(INPUT_GET,"operazione",FILTER_SANITIZE_ADD_SLASHES);
        $comunicazione = new Comunicazione($geecomDb, filter_input(INPUT_GET, "id"));
    }
    else {
        $operazione = filter_input(INPUT_POST,"operazione",FILTER_SANITIZE_ADD_SLASHES);
        $comunicazione = new Comunicazione($geecomDb, filter_input(INPUT_POST, "id"));
    }

    // dato che serve in molti switch per capire la pagina a cui l'utente deve essere rediretto
    $datiProdottoGeecom = $geecomDb->leggiSingolaRiga("geec_prodotti", 2) ;
    $percorsoGeecomAdmin = GeneratoreUrl::creaUrlAreaAmministrativa($impostazioni,$datiProdottoGeecom);
    
    switch ($operazione) {
        case 'crea':
            controlloAccessoAdmin();
            
            $dataCreazione     = date("Y-m-d");
            $oggetto = filter_input(INPUT_POST,"oggetto",FILTER_SANITIZE_ADD_SLASHES);
            $testo   = filter_input(INPUT_POST,"testo",FILTER_SANITIZE_ADD_SLASHES);
            $template= filter_input(INPUT_POST,"template",FILTER_SANITIZE_ADD_SLASHES);
            $inviaEmail    = (filter_input(INPUT_POST,"inviaEmail")=="si") ? "si" : "no";
            $inviaNotifica = (filter_input(INPUT_POST,"inviaNotifica")=="si") ? "si" : "no";
            $gruppiDestinatari = $_POST["gruppi"];
            
            $comunicazione->setTipo("comunicazione");
            $comunicazione->setOggetto($oggetto);
            $comunicazione->setInviaMail($inviaEmail);
            $comunicazione->setInviaNotifica($inviaNotifica);
            $comunicazione->setTesto($testo);
            $comunicazione->setTemplate($template);
            $comunicazione->setAutore($_SESSION["geecomAdmin_nomeCognome"]);
            $analisiComunicazione = $comunicazione->eseguiAnalisi();
            $comunicazione->setEfficacia($analisiComunicazione["esitoTesto"]);
            $id = $comunicazione->crea();
        
            foreach($gruppiDestinatari as $gruppoDestinatario) {
                $queryInserimentoGruppi="INSERT INTO geecAd_gruppiDestinatari VALUES(NULL,{$id},0,$gruppoDestinatario)";
                $geecomDb->eseguiQueryScrittura($queryInserimentoGruppi);
            }
            
            if($id>0) {
                header("Location: $percorsoGeecomAdmin/creaComunicazione.php?id=$id");
            }
            else {
                header("Location: $percorsoGeecomAdmin/gestioneComunicazioni.php?status=400");
            }
            break;
        case 'modifica':
            controlloAccessoAdmin();
            $oggetto = filter_input(INPUT_POST,"oggetto",FILTER_SANITIZE_ADD_SLASHES);
            $testo   = filter_input(INPUT_POST,"testo",FILTER_SANITIZE_ADD_SLASHES);
            $template= filter_input(INPUT_POST,"template",FILTER_SANITIZE_ADD_SLASHES);
            $inviaEmail    = (filter_input(INPUT_POST,"inviaEmail")=="si") ? "si" : "no";
            $inviaNotifica = (filter_input(INPUT_POST,"inviaNotifica")=="si") ? "si" : "no";
            $gruppiDestinatari = $_POST["gruppi"];
            
            $comunicazione->setTipo("comunicazione");
            $comunicazione->setOggetto($oggetto);
            $comunicazione->setTesto($testo);
            $comunicazione->setInviaMail($inviaEmail);
            $comunicazione->setInviaNotifica($inviaNotifica);
            $comunicazione->setTemplate($template);
            $comunicazione->setAutore($_SESSION["geecomAdmin_nomeCognome"]);
            $analisiComunicazione = $comunicazione->eseguiAnalisi();
            $comunicazione->setEfficacia($analisiComunicazione["esitoTesto"]);
            $comunicazione->modifica();
            header("Location: $percorsoGeecomAdmin/creaComunicazione.php?id={$comunicazione->getId()}&status=200");
            break;
        case 'aggiungiComponente':
            $idComponente = filter_input(INPUT_GET,"idComponente",FILTER_SANITIZE_NUMBER_INT);

            //recupero l'ultima posizione occupata nella mail
            $queryUltimaPosizione = "SELECT posizione FROM geecAd_composizioneComunicazioni WHERE idComunicazione={$comunicazione->getId()} ORDER BY posizione DESC LIMIT 1";
            $risPosizione = $geecomDb->eseguiQueryLettura($queryUltimaPosizione);
            $ultimaPosizione = $risPosizione->fetch_assoc();
            $posizione = $ultimaPosizione["posizione"]+1;

            // creo l'occorrenza del componente con i dati passati in input
            // la tabella geecB_composizionePagine dispone di altri campi che non vengono inseriti 
            // qui perché vengono inizializzati con i valori di default
            $queryAggiornamentoProdotto = "INSERT INTO `geecAd_composizioneComunicazioni` (`id`, `idComunicazione`, `idComponente`, `testo`, `posizione`,`altreOpzioni`) "
                    . "VALUES(NULL,{$comunicazione->getId()},'$idComponente','',$posizione,'')";
            $geecomDb->eseguiQueryScrittura($queryAggiornamentoProdotto);

            header("Location: $percorsoGeecomAdmin/creaComunicazione.php?id={$comunicazione->getId()}");
            break;
        case 'modificaComponente':
            $idComponente = filter_input(INPUT_POST,"idComponente",FILTER_SANITIZE_NUMBER_INT);
            $datiComponente = $geecomDb->leggiSingolaRiga("geecAd_composizioneComunicazioni", $idComponente); // recupero i dati sul componente

            if(isset($_POST["opzioneTagH"])) {
                $altreOpzioni .= "opzioneTagH=".filter_input(INPUT_POST, "opzioneTagH", FILTER_SANITIZE_STRING).";";
            }
            if(isset($_POST["opzioneAllineamento"])) {
                $altreOpzioni .= "opzioneAllineamento=".filter_input(INPUT_POST, "opzioneAllineamento", FILTER_SANITIZE_STRING).";";
            }
            if(isset($_POST["linkPulsante"])) {
                $altreOpzioni .= "linkPulsante=".filter_input(INPUT_POST, "linkPulsante", FILTER_SANITIZE_STRING).";";
            }
            if(isset($_POST["colore"])) {
                $altreOpzioni .= "colore=".filter_input(INPUT_POST, "colore", FILTER_SANITIZE_ADD_SLASHES).";";
            }
            $modificaTesto = "testo='".filter_input(INPUT_POST, "testo", FILTER_SANITIZE_ADD_SLASHES)."',";

            if(isset($_FILES['file'])) {
                $tipiFileAmmessi = ["image/png","image/jpeg","image/webp","image/gif"];
                $percorsoBase = "immagini/comunicazioni/";

                if($_FILES['file']['name']=="") { //se non c'è l'immagine percorsoFoto = vuoto
                    $modificaTesto ="";
                }
                else { //se c'è l'immagine viene salvata e inserita nel percorso foto (o audio)

                    $gestoreUpload = new GestoreUpload("file", $tipiFileAmmessi, 8, "../$percorsoBase", 0, "");
                    $esitoUpload  = $gestoreUpload->salvaFile();
                    if($esitoUpload["percorso"]!="") {
                        $percorsoFile  = str_replace("../","",$esitoUpload["percorso"]);
                        $modificaTesto ="testo='$percorsoFile', ";

                        // se nelle impostazioni è spuintata la voce  "ottimizza immagini caricate" viene modificata
                        if($impostazioni["ottimizzaImmaginiCaricate"]=="si") {
                            $elaboratoreImmagini = new ElaboratoreImmagini($esitoUpload["percorso"]);
                            if($elaboratoreImmagini->getAltezza()>$impostazioni["altezzaImmagine"]) {
                                $elaboratoreImmagini->modificaInScala("altezza", $impostazioni["altezzaImmagine"], $esitoUpload["percorso"]);
                            }
                        }
                    }
                    else {
                        $modificaTesto = "";
                    }
                }
            }

            $queryAggiornamentoProdotto = "UPDATE geecAd_composizioneComunicazioni SET $modificaTesto altreOpzioni='$altreOpzioni' WHERE id=$idComponente";
            $geecomDb->eseguiQueryScrittura($queryAggiornamentoProdotto);

            header("Location: $percorsoGeecomAdmin/creaComunicazione.php?id={$datiComponente["idComunicazione"]}&status=240");
            break;
        case 'eliminaComponente':
            $id = filter_input(INPUT_GET,'id',FILTER_SANITIZE_NUMBER_INT);
            $geecomDb->eseguiQueryCancellazione("geecAd_composizioneComunicazioni", $id);
            echo "ok";
            break;
        case 'modificaPosizioneComponente':
            $idComponente = filter_input(INPUT_POST,'idComponente',FILTER_SANITIZE_NUMBER_INT);
            $posizione    = filter_input(INPUT_POST,'posizione',FILTER_SANITIZE_NUMBER_INT);

            $comunicazione->caricaDatiDalDatabase();
            $comunicazione->modificaPosizioneComponente($idComponente,$posizione);
            echo "ok";
            break;
        case 'stampaComponenti':
            $comunicazione->stampaComponenti();
            break;
        case 'invia':
            controlloAccessoAdmin();
            $oggetto = filter_input(INPUT_POST,"oggetto",FILTER_SANITIZE_ADD_SLASHES);
            $testo   = filter_input(INPUT_POST,"testo",FILTER_SANITIZE_ADD_SLASHES);
            $template= filter_input(INPUT_POST,"template",FILTER_SANITIZE_ADD_SLASHES);
            $inviaEmail    = (filter_input(INPUT_POST,"inviaEmail")=="si") ? "si" : "no";
            $inviaNotifica = (filter_input(INPUT_POST,"inviaNotifica")=="si") ? "si" : "no";
            $gruppiDestinatari = $_POST["gruppi"];
            
            $comunicazione->setTipo("comunicazione");
            $comunicazione->setOggetto($oggetto);
            $comunicazione->setTesto($testo);
            $comunicazione->setInviaMail($inviaEmail);
            $comunicazione->setInviaNotifica($inviaNotifica);
            $comunicazione->setTemplate($template);
            $comunicazione->setAutore($_SESSION["geecomAdmin_nomeCognome"]);
            $comunicazione->setStato("inviata");
            $comunicazione->modifica();
            
            $datiEmail = $geecomDb->leggiSingolaRiga("geec_templateEmail",$template);
            $link = $impostazioni['urlPiattaforma'];
	    
            $messaggioHTML = $comunicazione->generaCodice();
            
            foreach($gruppiDestinatari as $gruppoDestinatario) {
                $queryEsistenzaGruppo = "SELECT * FROM geecAd_gruppiDestinatari WHERE idComunicazione = {$comunicazione->getId()} AND idGruppoDestinatario = $gruppoDestinatario";
                $risDb = $geecomDb->eseguiQueryLettura($queryEsistenzaGruppo);
                
                if($risDb->num_rows>0) { // se il gruppo è già presente non lo inserisco nuovamente
                    
                }
                else { //altrimenti lo inserisco
                    $queryInserimentoGruppi="INSERT INTO geecAd_gruppiDestinatari VALUES(NULL,{$comunicazione->getId()},0,$gruppoDestinatario)";
                    $geecomDb->eseguiQueryScrittura($queryInserimentoGruppi);
                }
            }
            
            // se è stato selezionato l'invio della notifica via email vengono inviate le email
            if($inviaEmail=="si") {
                if(count($gruppiDestinatari)>0) {

                    //estraggo dal db tutti gli utenti a cui bisogna inviare l'email
                    $queryUtenti="SELECT * FROM geec_gruppiUtenti AS gu JOIN geec_utenti AS u ON gu.idUtente = u.id WHERE gu.idGruppo IN (SELECT idGruppoDestinatario FROM geecAd_gruppiDestinatari WHERE idComunicazione={$comunicazione->getId()})";
                    $risUtenti = $geecomDb->eseguiQueryLettura($queryUtenti);

                    require "../phpMailer/class.phpmailer.php";
                    require "../phpMailer/class.smtp.php";
                    $messaggio = new PHPmailer();

                    //invio le email a tutti gli utenti interessati
                    $dataInvio   = date("Y-m-d H:i");
                    $reportInvio = inviaEmail($messaggio,$impostazioni,$risUtenti,$oggetto,$messaggioHTML);
                    $query       = "UPDATE geecAd_comunicazioni SET mailInviate={$reportInvio["mailInviate"]}, mailNonInviate={$reportInvio["mailNonInviate"]},logInvio='{$reportInvio["logInvio"]}', dataInvio='$dataInvio' WHERE id={$comunicazione->getId()}";
                    $geecomDb->eseguiQueryScrittura($query);
                }
            }
            
            // se è stato selezionato l'invio della notifica vengono inviate le notifiche
            if($inviaNotifica=="si") {
                if(count($gruppiDestinatari)>0) {
            
                    //estraggo dal db tutti gli utenti a cui bisogna inviare l'email
                    $queryUtenti="SELECT * FROM geec_gruppiUtenti AS gu JOIN geec_utenti AS u ON gu.idUtente = u.id WHERE gu.idGruppo IN (SELECT idGruppoDestinatario FROM geecAd_gruppiDestinatari WHERE idComunicazione={$comunicazione->getId()})";
                    $risUtenti = $geecomDb->eseguiQueryLettura($queryUtenti);
                    inviaNotifiche($geecomDb, $risUtenti, $oggetto);
                    
                    $dataInvio = date("Y-m-d H:i");
                    $query     = "UPDATE geecAd_comunicazioni SET dataInvio='$dataInvio' WHERE id={$comunicazione->getId()}";
                    $geecomDb->eseguiQueryScrittura($query);
                }
            }
            
            header("Location: $percorsoGeecomAdmin/creaComunicazione.php?id={$comunicazione->getId()}&status=200");
            break;
        case 'inviaMailDiProva':
            $destinatario = filter_input(INPUT_POST,'destinatario',FILTER_SANITIZE_STRING);
            
            $comunicazione->caricaDatiDalDatabase();
            $codicemail      = $comunicazione->generaCodice();
            $generatoreEmail = new GeneratoreEmail($impostazione["nomeMittente"],$impostazioni["emailMittente"]);
            $generatoreEmail->invia($destinatario, $comunicazione->getOggetto(), $codicemail);
            echo "ok";
            break;
        case 'inviaDiNuovo':
            $idComunicazioneDuplicata = $comunicazione->duplica("");
            header("Location: $percorsoGeecomAdmin/creaComunicazione.php?id={$idComunicazioneDuplicata}&status=250");
            break;
        case 'elimina':
            controlloAccessoAdmin();
            $comunicazione->elimina();
            echo"ok";
            break;
        case 'generaCodice':
            $comunicazione->caricaDatiDalDatabase();
            echo $comunicazione->generaCodice();
            break;
        case 'creaComunicazioneUtente':
            controlloAccessoUtente();
            $oggetto = filter_input(INPUT_POST, "oggetto",FILTER_SANITIZE_ADD_SLASHES);
            $comunicazione->setId(filter_input(INPUT_POST,"id",FILTER_SANITIZE_NUMBER_INT));
            $comunicazione->setIdUtente($_SESSION["geecomUser_id"]);
            $comunicazione->setOggetto($oggetto);
            $comunicazione->setTipo(filter_input(INPUT_POST, "tipo",FILTER_SANITIZE_ADD_SLASHES));
            $comunicazione->setTesto(filter_input(INPUT_POST, "testo",FILTER_SANITIZE_ADD_SLASHES));
            $comunicazione->setStato("aperto");
            $comunicazione->setPriorita(filter_input(INPUT_POST, "priorita",FILTER_SANITIZE_ADD_SLASHES));
            $comunicazione->setAutore(filter_var($_SESSION["geecomUser_nomeCognome"],FILTER_SANITIZE_ADD_SLASHES));
            $idTicket = $comunicazione->crea();
            
            $notifica = new Notifica($geecomDb, 0, "Admin", "ticket", 0, "{$_SESSION["geecomUser_nomeCognome"]} ha creato un nuovo ticket con oggetto <b>$oggetto</b>","creaComunicazione.php?id={$comunicazione->getId()}","no", date("Y-m-d"));
            $notifica->crea();
            
            $tipiFileAmmessi = ["image/png","image/jpeg","image/webp","image/gif","application/pdf"];
            $percorsoBase  = "file/allegatiComunicazioni";
            
            if(isset($_FILES['file'])) {
                if($_FILES['file']['name']=="") { //se non c'è l'immagine percorsoFoto = vuoto
                    $modificaTesto ="";
                }
                else { //se c'è l'immagine viene salvata e inserita nel percorso foto (o audio)
                    $gestoreUpload = new GestoreUpload("file", $tipiFileAmmessi, 8, "../$percorsoBase", 0, uniqid());
                    $esitoUpload   = $gestoreUpload->salvaFile();
                    
                    if($esitoUpload["percorso"]!="") {
                        $percorsoFile  = str_replace("../","",$esitoUpload["percorso"]);
                        $comunicazione->aggiungiAllegato($percorsoFile);
                    }
                }
            }
            
            if(isset($_FILES['file2'])) {
                if($_FILES['file2']['name']=="") { //se non c'è l'immagine percorsoFoto = vuoto
                    $modificaTesto ="";
                }
                else { //se c'è l'immagine viene salvata e inserita nel percorso foto (o audio)

                    $gestoreUpload = new GestoreUpload("file2", $tipiFileAmmessi, 8, "../$percorsoBase", 0, uniqid());
                    $esitoUpload   = $gestoreUpload->salvaFile();
                    
                    if($esitoUpload["percorso"]!="") {
                        $percorsoFile  = str_replace("../","",$esitoUpload["percorso"]);
                        $comunicazione->aggiungiAllegato($percorsoFile);
                    }
                }
            }
            
            if(isset($_FILES['file3'])) {
                if($_FILES['file3']['name']=="") { //se non c'è l'immagine percorsoFoto = vuoto
                    $modificaTesto ="";
                }
                else { //se c'è l'immagine viene salvata e inserita nel percorso foto (o audio)

                    $gestoreUpload = new GestoreUpload("file3", $tipiFileAmmessi, 8, "../$percorsoBase", 0, uniqid());
                    $esitoUpload   = $gestoreUpload->salvaFile();
                    
                    if($esitoUpload["percorso"]!="") {
                        $percorsoFile  = str_replace("../","",$esitoUpload["percorso"]);
                        $comunicazione->aggiungiAllegato($percorsoFile);
                    }
                }
            }
            
            if(isset($_FILES['file4'])) {
                if($_FILES['file4']['name']=="") { //se non c'è l'immagine percorsoFoto = vuoto
                    $modificaTesto ="";
                }
                else { //se c'è l'immagine viene salvata e inserita nel percorso foto (o audio)

                    $gestoreUpload = new GestoreUpload("file4", $tipiFileAmmessi, 8, "../$percorsoBase", 0, uniqid());
                    $esitoUpload   = $gestoreUpload->salvaFile();
                    
                    if($esitoUpload["percorso"]!="") {
                        $percorsoFile  = str_replace("../","",$esitoUpload["percorso"]);
                        $comunicazione->aggiungiAllegato($percorsoFile);
                    }
                }
            }
            
            if(isset($_FILES['file5'])) {
                if($_FILES['file5']['name']=="") { //se non c'è l'immagine percorsoFoto = vuoto
                    $modificaTesto ="";
                }
                else { //se c'è l'immagine viene salvata e inserita nel percorso foto (o audio)

                    $gestoreUpload = new GestoreUpload("file5", $tipiFileAmmessi, 8, "../$percorsoBase", 0, uniqid());
                    $esitoUpload   = $gestoreUpload->salvaFile();
                    
                    if($esitoUpload["percorso"]!="") {
                        $percorsoFile  = str_replace("../","",$esitoUpload["percorso"]);
                        $comunicazione->aggiungiAllegato($percorsoFile);
                    }
                }
            }
            
            if($impostazioni["inviaNotificaMailNuoveComunicazioni"]=="si") {
                $indirizzoSito = str_replace(["http://","https://","https://www."],"",$impostazioni["urlPiattaforma"]);
                $generatoreEmail = new GeneratoreEmail("Geecom Admin", "geecom@$indirizzoSito");
                
                $oggetto = "Nuovo ticket creato su ".$impostazioni["nomePiattaforma"];
                $testo   = "Un utente ha creato un nuovo ticket, ecco il testo: <br>".$comunicazione->getTesto();
                $generatoreEmail->invia($impostazioni["mailNotifiche"], $oggetto, $testo);
            }
            header("Location: ../dettagliTicket.php?id=$idTicket&status=200");
            break;
        case 'rispondiTicket':
            controlloAccessoUtente();
            $testo = filter_input(INPUT_POST, "testo",FILTER_SANITIZE_ADD_SLASHES);
            $comunicazione->aggiungiRispostaTicket($testo,$_SESSION["geecomUser_nomeCognome"]);
            $comunicazione->caricaDatiDalDatabase();
            $oggetto  = filter_var($comunicazione->getOggetto(),FILTER_SANITIZE_ADD_SLASHES);
            
            $notifica = new Notifica($geecomDb, 0, "Admin", "ticket", 0, "{$_SESSION["geecomUser_nomeCognome"]} ha aggiunto una risposta al ticket con oggetto <b>$oggetto</b>", "creaComunicazione.php?id={$comunicazione->getId()}", "no", date("Y-m-d"));
            $notifica->crea();
            header("Location: ../dettagliTicket.php?id={$comunicazione->getId()}&status=222");
            break;
        case 'rispondiTicketAmministratore':
            controlloAccessoAdmin();
            $testo   = filter_input(INPUT_POST, "testo",FILTER_SANITIZE_ADD_SLASHES);
            $comunicazione->aggiungiRispostaTicket($testo,"Amministrazione");
            $comunicazione->caricaDatiDalDatabase();
            $oggetto = filter_var($comunicazione->getOggetto(),FILTER_SANITIZE_ADD_SLASHES);
            
            $notifica = new Notifica($geecomDb, $comunicazione->getIdUtente(), "Admin", "ticket", $comunicazione->getIdUtente(), "{$_SESSION["geecomAdmin_nomeCognome"]} ha aggiunto una risposta al ticket con oggetto <b>$oggetto</b>", "dettagliTicket.php?id={$comunicazione->getId()}", "no", date("Y-m-d"));
            $notifica->crea();
            
            $indirizzoSito   = str_replace(["http://","https://","https://www."],"",$impostazioni["urlPiattaforma"]);
            $generatoreEmail = new GeneratoreEmail("Geecom Admin", "geecom@$indirizzoSito");

            $datiUtente  = $geecomDb->leggiSingolaRiga("geec_utenti",$comunicazione->getIdUtente());
            $oggettoMail = "Risposta al tuo ticket $oggetto";
            $testoMail   = "{$_SESSION["geecomAdmin_nomeCognome"]} ha aggiunto una risposta al tuo ticket, ecco il testo: <br>$testo";
            $generatoreEmail->invia($datiUtente["email"], $oggettoMail, $testoMail);
            
            header("Location: $percorsoGeecomAdmin/creaComunicazione.php?id={$comunicazione->getId()}&status=222");
            break;
        case 'chiudiComunicazioneAdmin':
            controlloAccessoAdmin();
            $comunicazione->cambiaStato("chiuso");

            $comunicazione->caricaDatiDalDatabase();
            $stringaNotifica = ($comunicazione->getTipo()=="ticket") ? "{$_SESSION["geecomAdmin_nomeCognome"]} ha chiuso la segnalazione con oggetto <b>{$comunicazione->getOggetto()}</b>" : "{$_SESSION["geecomAdmin_nomeCognome"]} ha chiuso il ticket con oggetto <b>{$comunicazione->getOggetto()}</b>";
            $notifica = new Notifica($geecomDb, $comunicazione->getIdUtente(), "Admin", $comunicazione->getTipo(), 0, filter_var($stringaNotifica,FILTER_SANITIZE_ADD_SLASHES), '', "no", date("Y-m-d"));
            $notifica->crea();
            echo "ok";
            break;
        case 'chiudiTicket':
            controlloAccessoUtente();
            $comunicazione->cambiaStato("chiuso");

            $comunicazione->caricaDatiDalDatabase();
            $oggetto  = filter_var($comunicazione->getOggetto(),FILTER_SANITIZE_ADD_SLASHES);            
            $notifica = new Notifica($geecomDb, 0, "Admin", "ticket", 0, "{$_SESSION["geecomUser_nomeCognome"]} ha chiuso il ticket con oggetto <b>$oggetto</b>", '', "no", date("Y-m-d"));
            $notifica->crea();
            echo "ok";
            break;
        case 'cambiaIdElemento':
            $id         = filter_input(INPUT_GET,'id',FILTER_SANITIZE_NUMBER_INT);
            $idElemento = filter_input(INPUT_GET,'idElemento',FILTER_SANITIZE_NUMBER_INT);
            $query = "UPDATE geecAd_composizioneComunicazioni SET testo=$idElemento WHERE id=$id";
            $geecomDb->eseguiQueryScrittura($query);
            echo "ok";
            break;
    }
